import React, { useState } from "react";
import Button from "react-bootstrap/Button";
import Form from "react-bootstrap/Form";
import Col from "react-bootstrap/Col";
import { Link, useParams } from "react-router-dom";
import { createProblem } from "./api-quiz";
import authHelpers from "../auth/auth-helpers";
import Modal from "react-bootstrap/esm/Modal";

function NewProblem({ addProblem }) {
  const { quizId } = useParams();
  const [answers, setAnswers] = useState([""]);
  const [question, setQuestion] = useState("");
  const [correct, setCorrect] = useState()
  const [show, setShow] = useState(false);

  const jwt = authHelpers.isAuthenticated();

  const addAnswer = () => {
    setAnswers([...answers, ""]);
  };

  const removeAnswer = (index) => {
    const list = [...answers];
    list.splice(index, 1);
    setAnswers(list);
  };

  const handleAnswer = (event, index) => {
    const { value } = event.target;
    const list = [...answers];
    list[index] = value;
    setAnswers(list);
  };

  const handleCorrect = (event) => {
    const { name, value } = event.target;
    console.log("name:", name, "value:", value);
    setCorrect(value)
  };

  const handleQuestion = (event) => {
    setQuestion(event.target.value);
  };

  const clickAddProblem = (event) => {
    event.preventDefault();
    const problem = {
      question,
      answers,
      quiz: quizId,
      correct: correct,
    };
    createProblem({ userId: jwt.user._id }, { t: jwt.token }, problem).then(
      (data) => {
        if (data.error) {
          console.log(data.error);
        } else {
          setQuestion(data.question);
          setAnswers(data.answers);
          setShow(true);
        }
      }
    );
    // addProblem({ question, answers });
  };

  return (
    <div>
      <Form>
        <Form.Group controlId="question">
          <Form.Label>Question</Form.Label>
          <Form.Control
            name="question"
            as="textarea"
            rows={5}
            onChange={handleQuestion}
          />
        </Form.Group>
        <Form.Label>Answers</Form.Label>
        {answers.map((answer, index) => {
          return (
            <Form.Row key={index}>
              <Col>
                <Form.Check
                  type="radio"
                  value={index}
                  name="correct"
                  onChange={handleCorrect}
                />
              </Col>
              <Col>
                <Form.Control
                  type="text"
                  value={answer}
                  onChange={(event) => handleAnswer(event, index)}
                />
              </Col>
              <Col>
                {answers.length !== 1 && (
                  <Button onClick={() => removeAnswer(index)}>Remove</Button>
                )}
                {answers.length - 1 === index && (
                  <Button onClick={addAnswer}>Add</Button>
                )}
              </Col>
            </Form.Row>
          );
        })}
        <Button onClick={clickAddProblem}>문제 추가</Button>
      </Form>
      <Modal show={show}>
        <Modal.Header>New Problem</Modal.Header>
        <Modal.Body>Problem successfully created.</Modal.Body>
        <Modal.Footer>
          <Link to={`/quiz/${quizId}`}>
            <Button>Go to quiz</Button>
          </Link>
        </Modal.Footer>
      </Modal>
    </div>
  );
}

export default NewProblem;
