import mongoose from 'mongoose'

const ProblemSchema = new mongoose.Schema({
  author: {
    type: mongoose.SchemaTypes.ObjectId,
    ref: 'User'
  },
  quiz: {
    type: mongoose.SchemaTypes.ObjectId,
    ref: 'Quiz'
  },
  type: String, // 객관식, 주관식 single/multiple choice
  created: {
    type: Date,
    default: Date.now
  },
  updated: Date,
  level: String,
  category: [String],
  score: Number, //문제당 할당 점수
  question: String, //질문
  answers: [String], // 선택형 항목
  correct: String, // 정답
  // correct: {
  //   type: mongoose.Schema.Types.ObjectId,
  //   ref: 'Answer'
  // }, // 정답; Answer Model 객체
})

export default mongoose.model('Problem', ProblemSchema)