import dbErrorHandler from "../helpers/dbErrorHandler.js"
import Course from "./course.model.js"

const create = async (req, res) => {
  try {
    const course = new Course(req.body)
    await course.save()
    return res.json(course)
  } catch (error) {
    return res.status(400).json({
      error: dbErrorHandler.getErrorMessage(error)
    })
  }
}

const list = async (req, res) => {
  try {
    const courses = await Course.find({}).exec()
    return res.json(courses)
  } catch (error) {
    return res.status(400).json({
      error: dbErrorHandler.getErrorMessage(error)
    })
  }
}

const read = (req, res) => {
  return res.json(req.course)
}

const courseById = async (req, res, next, id) => {
  // console.log('req.body in userById', req.body);
  try {
    let course = await Course.findById(id)
      .exec()
    if (!course) {
      return res.status(400).json({
        error: 'Course not found'
      })
    }
    req.course = course
    next()
  } catch (error) {
    return res.status(400).json({
      error: 'Could not retrieve course'
    })
  }
}

export default {
  create,
  list,
  read,
  courseById,
}