import React, { useState } from "react";
import Button from "react-bootstrap/Button";
import authHelpers from "../auth/auth-helpers";
import { create } from "./api-quiz";
import NewProblem from "./NewProblem";
import Problem from "./Problem";

function NewQuiz() {

  const [problems, setProblems] = useState([])

  const jwt = authHelpers.isAuthenticated();

  const addProblem = (problem) => {
    console.log(problem)
    setProblems([...problems, problem])
  }

  const clickSubmit = (event) => {
    event.preventDefault();

    const quizData = {
      problems
    }

    create({ userId: jwt.user._id }, { t: jwt.token }, quizData).then(
      (data) => {
        if (data.error) {
          console.log(data.error);
        } else {
          console.log(data);
        }
      }
    );
  };

  return (
    <div>
      <h1 className="text-center">
        Quiz List
      </h1>
      {
        problems.map((problem, index) => {
          return <Problem key={index} problem={problem} />
        })
      }
      <NewProblem addProblem={addProblem} />
      <Button onClick={clickSubmit}>퀴즈 저장</Button>
    </div>
  );
}

export default NewQuiz;
