import { signout } from "./api-auth"

const authenticate = (jwt, cb) => {
  if (typeof window !== 'undefined') {
    sessionStorage.setItem('jwt', JSON.stringify(jwt))
  }
  cb()
}

const isAuthenticated = () => {
  if (typeof window === 'undefined') {
    return false
  }

  const token = sessionStorage.getItem('jwt')
  if (token) {
    return JSON.parse(token)
  } else {
    return false
  }
}

const clearJwt = (cb) => {
  if (typeof window !== 'undefined') {
    sessionStorage.removeItem('jwt')
  }
  cb()
  signout().then(data => {
    document.cookie = "t=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;"
  })
}

export default {
  authenticate,
  isAuthenticated,
  clearJwt,
}