import dbErrorHandler from "../helpers/dbErrorHandler.js"
import Course from "./course.model.js"

const create = async (req, res) => {
  try {
    const course = new Course(req.body)
    await course.save()
    return res.json(course)
  } catch (error) {
    return res.status(400).json({
      error: dbErrorHandler.getErrorMessage(error)
    })
  }
}

const list = async (req, res) => {
  try {
    const courses = await Course.find({}).exec()
    return res.json(courses)
  } catch (error) {
    return res.status(400).json({
      error: dbErrorHandler.getErrorMessage(error)
    })
  }

}

export default {
  create,
  list,
}