import React, { useState, useEffect } from "react";
import { Link } from "react-router-dom";
import Container from "react-bootstrap/Container";
import Button from "react-bootstrap/Button";
import Form from "react-bootstrap/Form";
import Row from "react-bootstrap/Row";
import Col from "react-bootstrap/Col";
import Modal from "react-bootstrap/Modal";
import authHelpers from "../auth/auth-helpers";
import { create } from "./api-quiz";
// import NewProblem from "./NewProblem";
import Problem from "./Problem";
import { list } from "../course/api-course";

function NewQuiz() {
  const [problems, setProblems] = useState([]);
  const [quiz, setQuiz] = useState({});
  const [courses, setCourses] = useState([])
  const [values, setValues] = useState({
    title: "",
    problems: [],
    show: false,
    startAt: "",
    endAt: "",
    course: "",
  });

  const jwt = authHelpers.isAuthenticated();

  useEffect(() => {
    const abortController = new AbortController()
    const signal = abortController.signal
    list(signal).then(data => {
      if (data.error) {
        console.log(data.error);
      } else {
        console.log(data);
        setCourses(data)
      }
    })
    return () => {
      abortController.abort()
    }
  }, [])

  const handleChange = (event) => {
    const { name, value } = event.target;
    console.log("name", name, "value", value);
    console.log("values:", values);
    
    if (name === "course") {
      console.log(`${name}: ${courses[value]._id}`);
      setValues({ ...values, [name]: courses[value]._id });
    } else {
      setValues({ ...values, [name]: value });
    }
  };

  const handleUpdate = (index) => {
    console.log(`Quiz에서 handleUpdate ${index}번 실행`);
    // console.log(`Quiz에서 handleUpdate ${JSON.stringify(quiz.problems[index])}`);
  }

  const handleRemove = (index) => {
    console.log('handleRemove 실행');
    const problem = problems[index]
    console.log(problem);
    const list = [...problems]
    list.splice(index, 1)
    setProblems(list)
  }

  const addProblem = (problem) => {
    console.log(problem);
    setProblems([...problems, problem]);
  };

  const clickSubmit = (event) => {
    event.preventDefault();

    const quizData = {
      title: values.title,
      problems: problems,
      startAt: values.startAt,
      endAt: values.endAt,
      course: values.course,
    };

    console.log(quizData);

    // create({ userId: jwt.user._id }, { t: jwt.token }, quizData).then(
    //   (data) => {
    //     if (data.error) {
    //       console.log(data.error);
    //     } else {
    //       console.log(data);
    //       setQuiz(data);
    //       setShow(true);
    //     }
    //   }
    // );
  };

  return (
    <Container>
      <Form>
        <h1 className="text-center">New Quiz</h1>
        <Form.Group>
          <Form.Label htmlFor="title">Title</Form.Label>
          <Form.Control
            id="title"
            name="title"
            onChange={handleChange}
            placeholder="Title"
          />
        </Form.Group>
        <Form.Row>
          <Form.Group as={Col} md="4">
            <Form.Label>Course</Form.Label>
            <Form.Control
              as="select"
              id="course"
              name="course"
              onChange={handleChange}
            >
              {courses.map((course, i) => (
                <option key={i} value={i}>{course.name}</option>
              ))}
            </Form.Control>
          </Form.Group>
          <Form.Group as={Col} md="4">
            <Form.Label>Start Time</Form.Label>
            <Form.Control
              type="datetime-local"
              id="start-time"
              name="startAt"
              onChange={handleChange}
            />
          </Form.Group>
          <Form.Group as={Col} md="4">
            <Form.Label>End Time</Form.Label>
            <Form.Control
              type="datetime-local"
              id="start-time"
              name="endAt"
              onChange={handleChange}
            />
          </Form.Group>
        </Form.Row>

        {problems.map((problem, index) => {
          return <Problem key={index} problem={problem} number={index} onUpdate={handleUpdate} onRemove={handleRemove}/>;
        })}
        <NewQuizProblem addProblem={addProblem} />
        <Button onClick={clickSubmit}>퀴즈 저장</Button>
      </Form>

      <Modal show={values.show}>
        <Modal.Header>
          <Modal.Title>New Quiz</Modal.Title>
        </Modal.Header>
        <Modal.Body>New Quiz successfully created.</Modal.Body>
        <Modal.Footer>
          <Link to={`/quiz/${quiz._id}`}>
            <Button>Go to quiz</Button>
          </Link>
        </Modal.Footer>
      </Modal>
    </Container>
  );
}

export default NewQuiz;

function NewQuizProblem({ addProblem }) {
  // const { quizId } = useParams();
  const [answers, setAnswers] = useState([""]);
  const [question, setQuestion] = useState("");

  const addAnswer = () => {
    setAnswers([...answers, ""]);
  };

  const removeAnswer = (index) => {
    const list = [...answers];
    list.splice(index, 1);
    setAnswers(list);
  };

  const handleAnswer = (event, index) => {
    const { value } = event.target;
    const list = [...answers];
    list[index] = value;
    setAnswers(list);
  };

  const handleQuestion = (event) => {
    setQuestion(event.target.value);
  };

  const clickAdd = (event) => {
    event.preventDefault();
    addProblem({ question, answers });
  };

  return (
    <>
      {/* <Form> */}
      <Form.Group controlId="question">
        <Form.Label>Question</Form.Label>
        <Form.Control
          name="question"
          as="textarea"
          rows={5}
          onChange={handleQuestion}
        />
      </Form.Group>
      <Form.Label>Answers</Form.Label>
      {answers.map((answer, index) => {
        return (
          <Form.Row key={index}>
            <Col>
              <Form.Control
                type="text"
                value={answer}
                onChange={(event) => handleAnswer(event, index)}
              />
            </Col>
            <Col>
              {answers.length !== 1 && (
                <Button onClick={() => removeAnswer(index)}>Remove</Button>
              )}
              {answers.length - 1 === index && (
                <Button onClick={addAnswer}>Add</Button>
              )}
            </Col>
          </Form.Row>
        );
      })}
      <Button onClick={clickAdd}>문제 추가</Button>
      {/* </Form> */}
    </>
  );
}
