const create = async (user) => {
  try {
    const response = await fetch('/api/users/', {
      method: 'POST',
      headers: {
        'Accept': 'application/json',
        'Content-Type': 'application/json',
      },
      body: JSON.stringify(user)
    })
    return await response.json()
  } catch (error) {
    console.log(error)
  }
}

const read = async (userId, credentials) => {
  try {
    const response = await fetch('/api/users/' + userId, {
      method: 'GET',
      headers: {
        'Accept': 'application/json',
        'Content-Type': 'application/json',
        'Authorization': 'Bearer ' + credentials.t,
      },
    })
    return await response.json()
  } catch (error) {
    console.log(error)
  }
}

export {
  create,
  read,
}