import React, { useEffect, useState } from "react";
import { Link, useParams, Redirect } from 'react-router-dom';
import { listByUserId, read } from "./api-quiz";
import authHelpers from "../auth/auth-helpers";
import Timer from 'react-compound-timer';

function Problems({ problem, number, onUpdate, onRemove }) {

    let Time = 1800100

    const [timeout, settimeout] = useState(false)
    const { userId } = useParams();
    const [problems, setProblems] = useState([])
    const [quizzes, setQuizzes] = useState([{ title: "", author: "", course: "", problems: problems, }]);
    const jwt = authHelpers.isAuthenticated();
    const { quizId } = useParams();

    useEffect(() => {
        const abortController = new AbortController();
        const signal = abortController.signal;

        read({ quizId: quizId }, { t: jwt.token }, signal).then((data) => {
            if (data.error) {
                console.log(data.error);
            } else {
                console.log(data);
                setQuizzes(data);
            }
        });


        listByUserId({ userId: userId }, { t: jwt.token }, signal).then((data) => {
            if (data.error) {
                console.log(data.error);
            } else {
                console.log(data);
                setQuizzes(data);
            }
        });

        return () => {
            abortController.abort();
        };
    }, [userId]);

    return (
        <>
            <div>
                {console.log("quizzes=", quizzes)}
                <div className="container-fluid">
                    <div className="text-center  font-italic font-weight-bold py-2 text-muted">{quizzes[0].title}</div>
                    <div className="row justify-content-md-center">

                        <div className="col-md-auto mt-4">
                            <div className="mb-4small">문제 진척도 {quizzes[0]._id} </div>
                            <span className="h5 text-left text-danger ">
                                <Timer
                                    initialTime={Time}
                                    direction="backward"
                                    checkpoints={[
                                        {
                                            time: 1,
                                            callback: () => alert('시간이 초과되었습니다.'),
                                        },
                                        {
                                            time: 0,
                                            callback: () => settimeout(true),

                                        }
                                    ]}
                                >
                                    {() => (
                                        <>
                                            <Timer.Minutes /> : <Timer.Seconds></Timer.Seconds> / 30 : 00                        </>
                                    )}
                                </Timer>     {/* npm i react-compound-timer */}
                            </span>
                            <span className=" float-right ">
                            <Link to="/End">
                                    <a className="btn btn-danger">제출하기</a>
                                </Link>
                                {/* {(question.N - 1 === localQnA.length - 1)
                            ? <Link to="/end">
                                <button className="btn btn-outline-success" >제출</button>
                            </Link>
                            : <button type="button" className="btn btn-outline-dark" onClick={handleQuestion}>다음</button>} */}
                            </span>


                            <div className="h2 mt-5">
                                <span className='mr-4 font-weight-bold text-danger'>Quiz
                        <div>{quizzes[0].problems}</div>
                                </span>
                            </div>
                            <div className="mt-2">
                                <form>
                                    보기자리
                                    {quizzes.map((quiz,i)=>{
                                        return <div>{quiz.problems}</div>
                                    })}
                                {/* {question.Choose.map((a, index) =>
                                    <div>
                                        <input type="radio" name='answer' id={index} value={a} onChange={handleChange} checked={selected === String(a)} />
                                        <label className="font-weight-bold" htmlFor={a}>{a}</label>
                                    </div>
                                )} */}
                                </form>
                                <span className="h5 font-weight-bold"> Your Answer :</span>
                                <span className="h2 font-weight-bold text-danger"> selected</span>                         </div>
                        </div>
                        <div className="col">
                        </div>
                    </div>
                </div>
                {timeout ? <Redirect to='/End' /> : ''}
            </div>
        </>
        // <div>

        //     {quizzes.map((quiz, i) => {
        //         return (
        //             <Link key={i} to={`/quiz/${quiz._id}`}>
        //                 // <Card>
        //                     <Card.Body>
        //                         <Card.Title>
        //                             {i + 1}번. {quiz}
        //                         </Card.Title>
        //  Answers
        //  {problem.answers.map((answer, index) => {
        //                             return <Card.Text key={index}>{answer}</Card.Text>;
        //                         })}
        //                         <Link to={`/quiz/problem/edit/${problem._id}`}>
        //                             <Button onClick={(event) => onUpdate(number)}>수정</Button>
        //                         </Link>
        //                         <Button onClick={() => onRemove(number)}>삭제</Button>
        //                     </Card.Body>
        //                 </Card>
        //             </Link>
        //         );
        //     })}
        // </div>

        // <Card>
        //     <Card.Body>
        //         <Card.Title>
        //             {number + 1}번. {problem.question}
        //         </Card.Title>
        // Answers
        // {problem.answers.map((answer, index) => {
        //             return <Card.Text key={index}>{answer}</Card.Text>;
        //         })}
        //         <Link to={`/quiz/problem/edit/${problem._id}`}>
        //             <Button onClick={(event) => onUpdate(number)}>수정</Button>
        //         </Link>
        //         <Button onClick={() => onRemove(number)}>삭제</Button>
        //     </Card.Body>
        // </Card>
    );
}

export default Problems;
