import React, { useState, useContext } from 'react'
import authHelpers from './auth-helpers'

const AuthContext = React.createContext()

export const AuthProvider = ({ children }) => {
  const [authUser, setAuthUser] = useState(authHelpers.isAuthenticated())

  return (
    <AuthContext.Provider value={{ authUser, setAuthUser }}>
      {children}
    </AuthContext.Provider>
  )
}

export const useAuth = () => useContext(AuthContext)