import React from "react";
import { Route, Switch } from "react-router-dom";
import Signin from "./auth/Signin";
import Home from "./core/Home";
import Menu from "./core/Menu";
import Warning from "./core/Warning"
import End from "./core/End"
import NewQuiz from "./quiz/NewQuiz";
import Quiz from "./quiz/Quiz";
import Signup from "./user/Signup";
import Quizzes from "./quiz/Quizzes";
import EditProblem from "./quiz/EditProblem";
import NewProblem from "./quiz/NewProblem";
import Problems from './quiz/Problems';

function MainRouter() {
  return (
    <div>
      <Menu />
      <Switch>
        <Route exact path="/">
          <Home />
        </Route>
        <Route path="/warning">
          <Warning/>
        </Route>
        <Route path="/end">
          <End/>
        </Route>
        <Route path="/signin">
          <Signin />
        </Route>
        <Route path="/signup">
          <Signup />
        </Route>
        <Route path="/problems/:userId">
          <Problems />
        </Route>
        <Route path="/quiz/new">
          <NewQuiz />
        </Route>
        <Route path="/quiz/by/:userId">
          <Quizzes />
        </Route>
        <Route path="/quiz/problem/new/:quizId">
          <NewProblem />
        </Route>
        <Route path="/quiz/problem/edit/:problemId">
          <EditProblem />
        </Route>
        {/* 아래 "/quiz/:quizId" 는 "/quiz/by/:userId"와 순서 바뀌면 안된다. */}
        <Route path="/quiz/:quizId">
          <Quiz />
        </Route>
      </Switch>
    </div>
  );
}

export default MainRouter;
