import mongoose from 'mongoose'

const CourseSchema = new mongoose.Schema({
  name: String,
  description: String,
  image: {data: Buffer, contentType: String},
  instructor: {
    type: mongoose.SchemaTypes.ObjectId,
    ref: 'User'
  },
  created: {
    type: Date,
    default: Date.now
  },
  updated: Date,
})

export default mongoose.model('Course', CourseSchema)