import express from 'express'
import authCtrl from '../auth/auth.controller.js'
import userCtrl from '../user/user.controller.js'
import quizCtrl from './quiz.controller.js'

const router = express.Router()

router.route('/api/quiz/by/:userId')
  .post(authCtrl.requireSignin, authCtrl.hasAuthorization, userCtrl.isInstructor, quizCtrl.create)
  .get(authCtrl.requireSignin, authCtrl.hasAuthorization, quizCtrl.listByUserId)

router.route('/api/quiz/:quizId')
  .get(authCtrl.requireSignin, quizCtrl.isAuthor, quizCtrl.read)

router.route('/api/quiz/problem/:problemId')
  .get(authCtrl.requireSignin, quizCtrl.isProblemAuthor, quizCtrl.readProblem)

router.param('userId', userCtrl.userById)
router.param('quizId', quizCtrl.quizById)
router.param('problemId', quizCtrl.problemById)

export default router