import React, { useState } from "react";
import Button from "react-bootstrap/Button";
import Form from "react-bootstrap/Form";
import Modal from 'react-bootstrap/Modal'
import {Link} from 'react-router-dom'
import { create } from "./api-user";

function Signup() {
  const [values, setValues] = useState({
    name: "",
    password: "",
    email: "",
    open: false,
    error: "",
  });

  const handleChange = (name) => (event) => {
    const { value } = event.target;
    setValues({ ...values, [name]: value });
  };

  const handleSubmit = (event) => {
    // console.log(values);
    const user = {
      name: values.name || undefined,
      email: values.email || undefined,
      password: values.password || undefined,
    };
    create(user).then((data) => {
      if (data.error) {
        console.log(data.error);
        setValues({ ...values, error: data.error });
      } else {
        setValues({ ...values, error: "", open: true });
      }
    });
  };

  return (
    <div>
      <Form>
        <Form.Group>
          <Form.Label>Name</Form.Label>
          <Form.Control
            type="text"
            placeholder="Name"
            onChange={handleChange('name')}
          />
        </Form.Group>
        <Form.Group>
          <Form.Label>Password</Form.Label>
          <Form.Control
            type="password"
            placeholder="Password"
            onChange={handleChange('password')}
          />
        </Form.Group>
        <Form.Group>
          <Form.Label>Email</Form.Label>
          <Form.Control
            type="email"
            placeholder="Email"
            onChange={handleChange('email')}
          />
        </Form.Group>
        <Button onClick={handleSubmit}>확인</Button>
      </Form>
      <Modal show={values.open}>
        <Modal.Header>
          <Modal.Title>New Account</Modal.Title>
        </Modal.Header>
        <Modal.Body>
          New Account successfully created.
        </Modal.Body>
        <Modal.Footer>
          <Link to='/signin'>
            <Button>Sign in</Button>
          </Link>
        </Modal.Footer>
      </Modal>
    </div>
  );
}

export default Signup;
