import React from "react";
import {Link} from 'react-router-dom';
import Card from "react-bootstrap/Card";
import Button from "react-bootstrap/Button";

function Problem({ problem, number, onUpdate, onRemove }) {
  return (
    <Card>
      <Card.Body>
        <Card.Title>
          {number+1}번. {problem.question}
        </Card.Title>
        Answers
        {problem.answers.map((answer, index) => {
          return <Card.Text key={index}>{answer}</Card.Text>;
        })}
        <Link to={`/quiz/problem/edit/${problem._id}`}>
          <Button onClick={(event) => onUpdate(number)}>수정</Button>
        </Link>
        <Button onClick={onRemove}>삭제</Button>
      </Card.Body>
    </Card>
  );
}

export default Problem;
