import React, { useState } from "react";
import Button from "react-bootstrap/Button";
import authHelpers from "../auth/auth-helpers";
import { create } from "./api-quiz";
import NewProblem from "./NewProblem";
import Problem from "./Problem";

function NewQuiz() {
  const [title, setTitle] = useState('')
  const [problems, setProblems] = useState([])

  const jwt = authHelpers.isAuthenticated();

  const handleChange = (event) => {
    const { name, value } = event.target
    if (name === 'title') {
      setTitle(value)      
    }
  }

  const addProblem = (problem) => {
    console.log(problem)
    setProblems([...problems, problem])
  }

  const clickSubmit = (event) => {
    event.preventDefault();

    const quizData = {
      title,
      problems
    }

    create({ userId: jwt.user._id }, { t: jwt.token }, quizData).then(
      (data) => {
        if (data.error) {
          console.log(data.error);
        } else {
          console.log(data);
        }
      }
    );
  };

  return (
    <div>
      <h1 className="text-center">
        New Quiz
      </h1>
      <label htmlFor='title'>Title</label>
      <input id='title' name='title' onChange={handleChange} placeholder='Title' />
      {
        problems.map((problem, index) => {
          return <Problem key={index} problem={problem} number={index+1} />
        })
      }
      <NewProblem addProblem={addProblem} />
      <Button onClick={clickSubmit}>퀴즈 저장</Button>
    </div>
  );
}

export default NewQuiz;
