
const create = async (params, credentials, quiz) => {
  try {
    let response = await fetch('/api/quiz/by/' + params.userId, {
      method: 'POST',
      headers: {
        'Accept': 'application/json',
        'Content-Type': 'application/json',
        'Authorization': 'Bearer ' + credentials.t,
      },
      body: JSON.stringify(quiz),
    })
    return await response.json()
  } catch (error) {
    console.log(error)
  }
}

const read = async (params, credentials, signal) => {
  try {
    let response = await fetch('/api/quiz/' + params.quizId, {
      method: 'GET',
      signal: signal,
      headers: {
        'Accept': 'application/json',
        'Content-Type': 'application/json',
        'Authorization': 'Bearer ' + credentials.t,
      },
    })
    return await response.json()
  } catch (error) {
    console.log(error)
  }
}

const listByUserId = async (params, credentials, signal) => {
  try {
    let response = await fetch('/api/quiz/by/' + params.userId, {
      method: 'GET',
      signal: signal,
      headers: {
        'Accept': 'application/json',
        'Authorization': 'Bearer ' + credentials.t,
      },
    })
    return await response.json()
  } catch (error) {
    console.log(error)
  }
}

export {
  create,
  read,
  listByUserId,
}