import React, { useEffect, useState } from "react";
import Card from "react-bootstrap/Card";
import { Link, useParams } from "react-router-dom";
import authHelpers from "../auth/auth-helpers";
import { listByUserId } from "./api-quiz";

function Quizzes() {
  const { userId } = useParams();
  const [quizzes, setQuizzes] = useState([]);

  const jwt = authHelpers.isAuthenticated();

  useEffect(() => {
    const abortController = new AbortController();
    const signal = abortController.signal;

    listByUserId({ userId: userId }, { t: jwt.token }, signal).then((data) => {
      if (data.error) {
        console.log(data.error);
      } else {
        // console.log(data);
        setQuizzes(data);
      }
    });

    return () => {
      abortController.abort();
    };
  }, [userId]);

  return (
    <div>
      All Quizzes Here
      {quizzes.map((quiz, i) => {
        return (
          <Link key={i} to={`/quiz/${quiz._id}`}>
            <Card>
              <Card.Body>
                <Card.Title>제목: {quiz.title}</Card.Title>
                <Card.Text>만든날: {quiz.created}</Card.Text>
              </Card.Body>
            </Card>
          </Link>
        );
      })}
    </div>
  );
}

export default Quizzes;
