import React, { useState, useEffect } from "react";
import { useParams } from "react-router-dom";
import { read } from "./api-quiz";
import auth from "../auth/auth-helpers";
import Problem from './Problem'

function Quiz() {
  const { quizId } = useParams();
  const [quiz, setQuiz] = useState({});

  const jwt = auth.isAuthenticated();

  useEffect(() => {
    const abortController = new AbortController();
    const signal = abortController.signal;

    read({ quizId: quizId }, { t: jwt.token }, signal).then((data) => {
      if (data.error) {
        console.log(data.error);
      } else {
        setQuiz(data);
      }
    });
    return () => {
      abortController.abort();
    };
  }, [quizId]);

  const handleUpdate = (index) => {
    console.log(`Quiz에서 handleUpdate ${index}번 실행`);
    console.log(`Quiz에서 handleUpdate ${JSON.stringify(quiz.problems[index])}`);
  }

  const handleRemove = () => {
    console.log('Quiz에서 handleRemove 실행');
  }

  return (
    <div>
      <h2>제목: {quiz.title}</h2>
      {quiz.problems?.map((problem, i) => {
        return <Problem key={i} problem={problem} number={i} onUpdate={handleUpdate} onRemove={handleRemove} />;
      })}
    </div>
  );
}

export default Quiz;
