import User from './user.model.js';

const create = async (req, res) => {
  const user = new User(req.body)
  try {
    await user.save()
    return res.json({
      message: 'Succefully signed up!'
    })
  } catch (error) {
    return res.status(400).json({
      error: 'User creation error'
    })
  }
}

const list = async (req, res) => {
  try {
    let users = await User.find().select('name email updated created').exec()
    return res.json(users)
  } catch (error) {
    return res.status(400).json({
      error: 'User not found'
    })
  }
}

export default {
  create,
  list,
}