import React, { useState, useEffect } from "react";
import { Link, useParams } from "react-router-dom";
import { read, removeProblem, updateProblem } from "./api-quiz";
import auth from "../auth/auth-helpers";
import Button from "react-bootstrap/Button";
import EditableProblem from "./EditableProblem";
import Container from "react-bootstrap/Container";
import Row from "react-bootstrap/Row";
import Col from "react-bootstrap/Col";

function Quiz() {
  const { quizId } = useParams();
  const [quiz, setQuiz] = useState({});

  const jwt = auth.isAuthenticated();

  useEffect(() => {
    const abortController = new AbortController();
    const signal = abortController.signal;

    read({ quizId: quizId }, { t: jwt.token }, signal).then((data) => {
      if (data.error) {
        console.log(data.error);
      } else {
        console.log(data);
        setQuiz(data);
      }
    });
    return () => {
      abortController.abort();
    };
  }, [quizId]);

  const handleUpdate = (index, problem) => {
    console.log(`Quiz에서 handleUpdate ${index}번 실행`);
    console.log(
      `Quiz에서 handleUpdate ${JSON.stringify(quiz.problems[index])}`
    );
    console.log(
      `Quiz에서 handleUpdate updated problem ${JSON.stringify(problem)}`
    );
    updateProblem({ problemId: problem._id }, { t: jwt.token }, problem).then(
      (data) => {
        if (data.error) {
          console.log(data.error);
        } else {
          console.log(data);
          const list = [...quiz.problems];
          list[index] = data;
          console.log(list);
          setQuiz({ ...quiz, problems: list });
        }
      }
    );
  };

  const handleRemove = (index) => {
    console.log("Quiz에서 handleRemove 실행");
    const problem = quiz.problems[index];
    console.log(problem);
    removeProblem({ problemId: problem._id }, { t: jwt.token }).then((data) => {
      if (data.error) {
        console.log(data.error);
      } else {
        console.log("deleted Problem:", data);
        const list = [...quiz.problems];
        list.splice(index, 1);
        setQuiz({ ...quiz, problems: list });
      }
    });
  };

  return (
    <Container>
      <h2 className="text-center">제목: {quiz.title}</h2>
      <Row>
        <Col md={4}>과목: {quiz?.course?.name}</Col>
        <Col md={4}>시작: {quiz?.startAt}</Col>
        <Col md={4}>끝: {quiz?.endAt}</Col>
      </Row>
      {quiz.problems?.map((problem, i) => {
        // return <Problem key={i} problem={problem} number={i} onUpdate={handleUpdate} onRemove={handleRemove} />;
        return (
          <EditableProblem
            key={i}
            problem={problem}
            number={i}
            onUpdate={handleUpdate}
            onRemove={handleRemove}
          />
        );
      })}
      <Link to={`/quiz/problem/new/${quizId}`}>
        <Button>문제 추가</Button>
      </Link>
    </Container>
  );
}

export default Quiz;
