import formidable from 'formidable'
import fs from 'fs'
import quizModel from './quiz.model.js'

const create = async (req, res) => {
  const form = new formidable.IncomingForm()
  form.keepExtensions = true
  form.parse(req, async (err, fields, files) => {
    if (err) {
      return res.status(400).json({
        error: 'Image could not be uploaded'
      })
    }

    const quiz = new quizModel(fields)
    quiz.author = req.profile
    if (files.image) {
      quiz.image.data = fs.readFileSync(files.image.path)
      quiz.image.contentType = files.image.type
    }

    try {
      const result = await quiz.save()
      res.json(result)
    } catch (error) {
      return res.status(400).json({
        error: 'Quiz save db error'
      })
    }
  })
}

export default {
  create,
}