import mongoose from 'mongoose'

const QuestionSchema = new mongoose.Schema({
  type: String, // 객관식, 주관식 single/multiple choice
  created: {
    type: Date,
    default: Date.now
  },
  updated: Date,
  level: String,
  category: [String],
  score: Number, //문제당 할당 점수
  content: String, //질문
  choices: [String], // 선택형 항목
  correct: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Answer'
  }, // 정답; Answer Model 객체
})

export default mongoose.model('Question', QuestionSchema)