import React, { useState, useEffect, useContext } from "react";
import Navbar from "react-bootstrap/Navbar";
import Nav from "react-bootstrap/Nav";
import NavDropdown from "react-bootstrap/NavDropdown";
import Form from "react-bootstrap/Form";
import FormControl from "react-bootstrap/FormControl";
import Button from "react-bootstrap/Button";
import auth from "../auth/auth-helpers";
import { Link, useHistory } from "react-router-dom";
import { AuthContext } from "../auth/auth-context";

// import { Link } from "react-router-dom";

function Menu() {
  const authContext = useContext(AuthContext);
  const history = useHistory();

  console.log("Menu.jsx", history);
  console.log("authContext in Menu.jsx:", authContext);

  return (
    <Navbar sticky="top" bg="dark" variant="dark" expand="sm">
      <Navbar.Brand href="/">
        <i className="fas fa-child fa-2x"></i>
      </Navbar.Brand>
      <Navbar.Toggle aria-controls="basic-navbar-nav" />
      <Navbar.Collapse id="basic-navbar-nav">
        <Nav className="mr-auto">
          <Nav.Link href="#home">Home</Nav.Link>
          <Nav.Link href="#link">Link</Nav.Link>
          <NavDropdown title="Dropdown" id="basic-nav-dropdown">
            <NavDropdown.Item href="#action/3.1">Action</NavDropdown.Item>
            <NavDropdown.Item href="#action/3.2">
              Another action
            </NavDropdown.Item>
            <NavDropdown.Item href="#action/3.3">Something</NavDropdown.Item>
            <NavDropdown.Divider />
            <NavDropdown.Item href="#action/3.4">
              Separated link
            </NavDropdown.Item>
          </NavDropdown>
        </Nav>
        {authContext.authState ? (
          <Button
            onClick={() =>
              auth.clearJwt(() => {
                history.push("/");
                authContext.setAuthState(false);
              })
            }
          >
            Sign out
          </Button>
        ) : (
          <Link to="/signin">
            <Button>Sign in</Button>
          </Link>
        )}
      </Navbar.Collapse>
    </Navbar>
  );
}

export default Menu;
