import React, {useState} from 'react';
import { BrowserRouter } from 'react-router-dom'
import { AuthContext } from './auth/auth-context';
import authHelpers from './auth/auth-helpers';
import MainRouter from './MainRouter';

function App() {
  const [authState, setAuthState] = useState(authHelpers.isAuthenticated())
  return (
    <AuthContext.Provider value={{authState, setAuthState}}>
      <BrowserRouter>
        <MainRouter />
      </BrowserRouter>
    </AuthContext.Provider>
  );
}

export default App;
