const list = async (signal) => {
  try {
    let response = await fetch('/api/courses/', {
      method: 'GET',
      signal: signal,
      headers: {
        'Accept': 'application/json',
        'Content-Type': 'application/json',
      },
    })
    return await response.json()
  } catch (error) {
    console.log(error)
  }
}

const read = async (courseId, credentials) => {
  try {
    const response = await fetch('/api/courses/' + courseId, {
      method: 'GET',
      headers: {
        'Accept': 'application/json',
        'Content-Type': 'application/json',
        'Authorization': 'Bearer ' + credentials.t,
      },
    })
    return await response.json()
  } catch (error) {
    console.log(error)
  }
}

export {
  list, read
}
