import express from 'express'
import authCtrl from '../auth/auth.controller.js'
import userCtrl from '../user/user.controller.js'
import quizCtrl from './quiz.controller.js'

const router = express.Router()

router.route('/api/quiz/:userId')
  .post(authCtrl.requireSignin, authCtrl.hasAuthorization, userCtrl.isInstructor, quizCtrl.create)


router.param('userId', userCtrl.userById)
export default router