const authenticate = (jwt, cb) => {
  if (typeof window !== 'undefined') {
    sessionStorage.setItem('jwt', JSON.stringify(jwt))
  }
  cb()
}

const isAuthenticated = () => {
  if (typeof window === 'undefined') {
    return false
  }

  const token = sessionStorage.getItem('jwt')
  if (token) {
    return JSON.parse(token)
  } else {
    return false
  }
}

export default {
  authenticate,
  isAuthenticated,
}