import React, { useState } from "react";
import {Link} from 'react-router-dom'
import Button from "react-bootstrap/Button";
import Form from "react-bootstrap/Form";
import Col from "react-bootstrap/Col";
import Modal from "react-bootstrap/Modal";
import authHelpers from "../auth/auth-helpers";
import { create } from "./api-quiz";
// import NewProblem from "./NewProblem";
import Problem from "./Problem";

function NewQuiz() {
  const [title, setTitle] = useState('')
  const [problems, setProblems] = useState([])
  const [show, setShow] = useState(false)
  const [quiz, setQuiz] = useState({})

  const jwt = authHelpers.isAuthenticated();

  const handleChange = (event) => {
    const { name, value } = event.target
    if (name === 'title') {
      setTitle(value)      
    }
  }

  const addProblem = (problem) => {
    console.log(problem)
    setProblems([...problems, problem])
  }

  const clickSubmit = (event) => {
    event.preventDefault();

    const quizData = {
      title,
      problems
    }

    create({ userId: jwt.user._id }, { t: jwt.token }, quizData).then(
      (data) => {
        if (data.error) {
          console.log(data.error);
        } else {
          console.log(data);
          setQuiz(data)
          setShow(true)
        }
      }
    );
  };

  return (
    <div>
      <h1 className="text-center">
        New Quiz
      </h1>
      <label htmlFor='title'>Title</label>
      <input id='title' name='title' onChange={handleChange} placeholder='Title' />
      {
        problems.map((problem, index) => {
          return <Problem key={index} problem={problem} number={index} />
        })
      }
      <NewQuizProblem addProblem={addProblem} />
      <Button onClick={clickSubmit}>퀴즈 저장</Button>
      <Modal show={show}>
        <Modal.Header>
          <Modal.Title>New Quiz</Modal.Title>
        </Modal.Header>
        <Modal.Body>
          New Quiz successfully created.
        </Modal.Body>
        <Modal.Footer>
          <Link to={`/quiz/${quiz._id}`}>
            <Button>Go to quiz</Button>
          </Link>
        </Modal.Footer>
      </Modal>
    </div>
  );
}

export default NewQuiz;

function NewQuizProblem({ addProblem }) {
  // const { quizId } = useParams();
  const [answers, setAnswers] = useState([""]);
  const [question, setQuestion] = useState("");

  const addAnswer = () => {
    setAnswers([...answers, ""]);
  };

  const removeAnswer = (index) => {
    const list = [...answers];
    list.splice(index, 1);
    setAnswers(list);
  };

  const handleAnswer = (event, index) => {
    const { value } = event.target;
    const list = [...answers];
    list[index] = value;
    setAnswers(list);
  };

  const handleQuestion = (event) => {
    setQuestion(event.target.value);
  };

  const clickAdd = (event) => {
    event.preventDefault();
    addProblem({ question, answers });
  };

  return (
    <div>
      <Form>
        <Form.Group controlId="question">
          <Form.Label>Question</Form.Label>
          <Form.Control
            name="question"
            as="textarea"
            rows={5}
            onChange={handleQuestion}
          />
        </Form.Group>
        <Form.Label>Answers</Form.Label>
        {answers.map((answer, index) => {
          return (
            <Form.Row key={index}>
              <Col>
                <Form.Control
                  type="text"
                  value={answer}
                  onChange={(event) => handleAnswer(event, index)}
                />
              </Col>
              <Col>
                {answers.length !== 1 && (
                  <Button onClick={() => removeAnswer(index)}>Remove</Button>
                )}
                {answers.length - 1 === index && (
                  <Button onClick={addAnswer}>Add</Button>
                )}
              </Col>
            </Form.Row>
          );
        })}
        <Button onClick={clickAdd}>문제 추가</Button>
      </Form>
    </div>
  );
}
