import express from 'express'
import authCtrl from '../auth/auth.controller.js'
import userCtrl from '../user/user.controller.js'
import quizCtrl from './quiz.controller.js'

const router = express.Router()

router.route('/api/quiz/:userId')
  .post(authCtrl.requireSignin, authCtrl.hasAuthorization, userCtrl.isInstructor, quizCtrl.create) // 퀴즈 생성
  .get(authCtrl.requireSignin, authCtrl.hasAuthorization, quizCtrl.listByUserId) // 모든 퀴즈 반환

router.route('/api/quiz/by/:quizId')
  .get(authCtrl.requireSignin, quizCtrl.isAuthor, quizCtrl.read) // 퀴즈 하나 반환

router.route('/api/quiz/problem/:userId')
  .post(authCtrl.requireSignin, userCtrl.isInstructor, quizCtrl.createProblem) // 문제 생성

router.route('/api/quiz/problem/by/:problemId')
  .get(authCtrl.requireSignin, quizCtrl.isProblemAuthor, quizCtrl.readProblem) // 문제 반환
  .put(authCtrl.requireSignin, quizCtrl.isProblemAuthor, quizCtrl.updateProblem) // 문제 수정
  .delete(authCtrl.requireSignin, quizCtrl.isProblemAuthor, quizCtrl.removeProblem) // 문제 삭제

router.param('userId', userCtrl.userById)
router.param('quizId', quizCtrl.quizById)
router.param('problemId', quizCtrl.problemById)

export default router