import mongoose from 'mongoose'

const QuizSchema = new mongoose.Schema({
  author: {
    type: mongoose.SchemaTypes.ObjectId,
    ref: 'User'
  },
  title: String,
  score: Number,
  published: Boolean,
  created: {
    type: Date,
    default: Date.now
  },
  updated: Date,
  publishedAt: Date,
  startAt: Date,
  endAt: Date,
  problems: [{
    type: mongoose.SchemaTypes.ObjectId,
    ref: 'Problem'
  }], // Problem Schemas
  image: {
    type: Buffer,
    contentType: String,
  },
  course: {
    type: mongoose.SchemaTypes.ObjectId,
    ref: 'Course'
  }
})

export default mongoose.model('Quiz', QuizSchema)