import express from 'express'
import authCtrl from '../auth/auth.controller.js'
import userCtrl from '../user/user.controller.js'
import courseCtrl from './course.controller.js'

const router = express.Router()

router.route('/api/courses')
  .get(courseCtrl.list)

router.route('/api/courses/:courseId')
  .get(courseCtrl.read)

router.route('/api/courses/by/:userId')
  .post(authCtrl.requireSignin, authCtrl.hasAuthorization, userCtrl.isAdmin, courseCtrl.create)

router.param('userId', userCtrl.userById)
router.param('courseId', courseCtrl.courseById)

export default router