import mongoose from 'mongoose'

const CourseSchema = new mongoose.Schema({
  name: String,
  description: String,
  code: {
    type: String,
    unique: true,
  }, // 코스 코드
  class: {
    type: Number,
    default: 0,
  }, // 분반
  image: {data: Buffer, contentType: String},
  instructor: {
    type: mongoose.SchemaTypes.ObjectId,
    ref: 'User'
  },
  created: {
    type: Date,
    default: Date.now
  },
  updated: Date,
})

export default mongoose.model('Course', CourseSchema)