import React, { useState, useEffect } from "react";
import { Link, useParams } from "react-router-dom";
import Form from "react-bootstrap/Form";
import Col from "react-bootstrap/Col";
import Button from "react-bootstrap/Button";
import Modal from 'react-bootstrap/Modal'
import authHelpers from "../auth/auth-helpers";
import { readProblem, updateProblem } from "./api-quiz";

function EditProblem() {
  const { problemId } = useParams();
  const [problem, setProblem] = useState({show: false});

  const jwt = authHelpers.isAuthenticated();

  useEffect(() => {
    const abortController = new AbortController();
    const signal = abortController.signal;

    readProblem({ problemId }, { t: jwt.token }, signal).then((data) => {
      if (data.error) {
        console.log(data.error);
      } else {
        console.log(data);
        setProblem(data);
      }
    });
    return () => {
      abortController.abort();
    };
  }, [problemId]);

  const addAnswer = () => {
    setProblem({...problem, answers: [...problem.answers, '']})
  };

  const removeAnswer = (index) => {
    const list = [...problem.answers];
    list.splice(index, 1);
    setProblem({...problem, answers: list})
  };

  const handleAnswer = (event, index) => {
    const { value } = event.target;
    const list = [...problem.answers];
    list[index] = value;
    setProblem({...problem, answers: list})
  };

  const handleQuestion = (event) => {
    const {value} = event.target
    setProblem({...problem, question: value})
  };

  const handleSave = (event) => {
    event.preventDefault();
    console.log(problem);
    updateProblem({problemId}, {t: jwt.token}, problem).then(data => {
      if (data.error) {
        console.log(data.error);
      } else {
        console.log(data);
        setProblem({...data, show: true})
      }
    })
  };

  return (
    <div>
      문제를 수정합니다.
      <Form>
        <Form.Group controlId="question">
          <Form.Label>Question</Form.Label>
          <Form.Control
            name="question"
            as="textarea"
            value={problem.question}
            rows={5}
            onChange={handleQuestion}
          />
        </Form.Group>
        <Form.Label>Answers</Form.Label>
        {problem.answers?.map((answer, index) => {
          return (
            <Form.Row key={index}>
              <Col>
                <Form.Control
                  type="text"
                  value={answer}
                  onChange={(event) => handleAnswer(event, index)}
                />
              </Col>
              <Col>
                {problem.answers.length !== 1 && (
                  <Button onClick={() => removeAnswer(index)}>Remove</Button>
                )}
                {problem.answers.length - 1 === index && (
                  <Button onClick={addAnswer}>Add</Button>
                )}
              </Col>
            </Form.Row>
          );
        })}
        <Button onClick={handleSave}>저장</Button>
      </Form>
      <Modal show={problem.show}>
        <Modal.Header>
          <Modal.Title>Edit Problem</Modal.Title>
        </Modal.Header>
        <Modal.Body>
          Problem successfully modified.
        </Modal.Body>
        <Modal.Footer>
          <Link to={`/quiz/${problem.quiz}`}>
            <Button>Go to quiz</Button>
          </Link>
        </Modal.Footer>
      </Modal>
    </div>
  );
}

export default EditProblem;
