import React, { useState, useEffect, useRef } from 'react';
import AdminQuiz from './AdminQuiz'
import AdminSetting from './AdminSetting'

let QuizBtn = []

function Admin() {

    const [result, setresult] = useState('')
    const [QuizBtnCount, setQuizBtnCount] = useState(4)
    const indexRef = useRef(0)
    const dbRef = useRef([])

    useEffect(() => {
        if (JSON.parse(localStorage.getItem('QnA'))) {
            dbRef.current=JSON.parse(localStorage.getItem('QnA'))
        }
    }, [])
    function handleClickSetting() {
        setresult(<AdminSetting />)
    }

    function handleClickQuiz(e) {
        indexRef.current = Number(e.target.id) - 1
        // console.log(dbRef.current, indexRef.current)

        if(dbRef.current[e.target.id-1]){
            setresult(<AdminQuiz quizNum={e.target.id} fn={handleClickSave} data={dbRef.current[e.target.id-1]} />)
        }
        else{
            dbRef.current[e.target.id-1] = {'Q':'x', 'Choose':[0,0,0,0], 'A':'x'}
            setresult(<AdminQuiz quizNum={e.target.id} fn={handleClickSave} data={dbRef.current[e.target.id-1]} />)
        }
    }

    function handleClickAddQuiz() {
        QuizBtn.push(
            <button type='button' className='btn btn-outline-primary' id={QuizBtnCount} onClick={handleClickQuiz}>Quiz {QuizBtnCount}</button>
        )
        setQuizBtnCount(QuizBtnCount + 1)
    }

    function handleClickSave(QnAadmin) {
        console.log(QnAadmin, indexRef.current)
        dbRef.current[indexRef.current] = QnAadmin
        localStorage.setItem('QnA', JSON.stringify(dbRef.current))

    }
    return (
        <>
            <div className="container-fluid bg-light">
                <div className="row justify-content-md-center mt-5">
                    <div className="col-2 text-center border py-5 bg-white">
                        <div className="py-3 border-top border-bottom">
                            <h5 className="font-weight-bold">설정</h5>
                        </div>
                        <div className="border-bottom py-4">
                            <button type="button" className="btn btn-info" onClick={handleClickSetting}>Setting</button>
                        </div>
                        <div className="btn-group-vertical py-4">
                            <button type="button" className="btn btn-outline-primary" id={1} onClick={handleClickQuiz}>Quiz 1</button>
                            <button type="button" className="btn btn-outline-primary" id={2} onClick={handleClickQuiz}>Quiz 2</button>
                            <button type="button" className="btn btn-outline-primary" id={3} onClick={handleClickQuiz}>Quiz 3</button>
                            {QuizBtn.map((element) => element)}
                            <button type="button" className="btn btn-outline-primary" onClick={handleClickAddQuiz}>+</button>

                        </div>
                    </div>

                    <div className="col-8 ">
                        {result}
                    </div>
                </div>
            </div>


        </>
    )
}

export default Admin