import React, { useState } from 'react'
import { Link } from 'react-router-dom';
import Timer from 'react-compound-timer'; // 타이머쓰기위해 import
import logo from './img/img_question.png'
import fight from './img/img_quiz.png'
import './Quiz.css'


const QnA = [
    { Q: "6 X 4 = ?", Choose: [6, 12, 18, 24], A: "4", N: 1 },
    { Q: "3 + 3 = ?", Choose: [2, 4, 6, 8], A: "3", N: 2 },
    { Q: "3 - 1 = ?", Choose: [1, 2, 3, 4], A: "2", N: 3 }
]

function Quiz() {
    const [question, setQuestion] = useState({
        ...QnA[0],
        i: 0,
        page: 0,
    })
    const [selected, setSelected] = useState("")  //선택한 답을 보여줄 것들
    // const [checked, setChecked] = useState(false)

    function handleQuestion() {
        setQuestion({ ...QnA[question.i + 1], i: question.i + 1, page: question.page + 1 })
        // setChecked(false)
    }

    let handleChange = (ev) => {
        // ev.preventDefault()  //새로고침 안되도록
        setSelected(ev.target.value)  //selected값 변경
        let checked_number = ev.target.id;

        localStorage.setItem('답' + (question.N), Number(checked_number) + 1)
        localStorage.setItem('정답' + (question.N), QnA[question.N - 1].A)

    }
    return (
        <div className="container-fluid position-absolute">
            <div className="text-center h2 font-weight-bold bg-warning py-2">미적분학 퀴즈</div>
            <div className="row justify-content-md-center" >
                <div className="col text-right">
                    <h1>
                        <img src={logo} width='50' height='50' alt='question' />
                    </h1>
                </div>
                <div className="col-md-auto">
                    <div className="h2 mt-2">
                        {question.Q}
                    </div>
                    <div className="mt-2">
                        <form>
                            {question.Choose.map((a, index) =>
                                <div key={index}>
                                    <input type="radio" name='answer' id={index} value={a} onClick={handleChange} />
                                    <label className="font-weight-bold" htmlFor={a}>{a}</label>
                                </div>
                            )}
                            <input hidden type="submit" value="확인" /> {/*버튼 숨김*/}
                        </form>
                        <span className="h5 font-weight-bold"> Your Answer :</span>
                        <span className="h2 font-weight-bold text-danger"> {selected}</span>  {/* 선택한 값 보여줌 */}
                        <div className="text-center my-3"> {(question.page === QnA.length - 1)
                            ? <Link to="/end">
                                <button className="btn btn-outline-success">제출</button>
                            </Link>
                            : <button type="button" className="btn btn-outline-dark" onClick={handleQuestion}>다음</button>
                        }
                        </div>
                        <p className="h3 text-center text-danger ">
                            <Timer
                                initialTime={3600000}
                                direction="backward"
                                checkpoints={[
                                    {
                                        time: 0,
                                        callback: <Link to="/end">제출</Link>
                                        //  history.go(1)
                                    }
                                ]}
                            >
                                {() => (
                                    <>
                                        <Timer.Minutes /> : <Timer.Seconds></Timer.Seconds> / 60 : 00                        </>
                                )}
                            </Timer>     {/* npm i react-compound-timer */}
                        </p>
                    </div>
                </div>
                <div className="col">
                </div>
            </div>
        </div>
    )



}


export default Quiz;
