import React, { useState } from 'react'
import { Link } from 'react-router-dom';
import Timer from 'react-compound-timer'; // 타이머쓰기위해 import
import logo from './img/img_question.png'
import fight from './img/img_quiz.png'

const QnA = [
    { Q: "6 X 4 = ?", Choose: [6, 12, 18, 24], A: "4", N: 1 },
    { Q: "3 + 3 = ?", Choose: [2, 4, 6, 8], A: "3", N: 2 },
    { Q: "3 - 1 = ?", Choose: [1, 2, 3, 4], A: "2", N: 3 }
]

let Answers = []
let Solutions = [4, 3, 2]
localStorage.setItem('Solutions', JSON.stringify(Solutions))

function Quiz() {
    let [question, setQuestion] = useState({
        ...QnA[0],
        i: 0,
        page: 0,
    })
    let [selected, setSelected] = useState("")  //선택한 답을 보여줄 것들

    function handleQuestion() {
        setQuestion({ ...QnA[question.i + 1], i: question.i + 1, page: question.page + 1 })
    }

    let handleChange = (ev) => {
        ev.preventDefault()  //새로고침 안되도록
        setSelected(ev.target.value)  //selected값 변경

        Answers[question.N - 1] = Number(ev.target.id)+1

        localStorage.setItem('Answers', JSON.stringify(Answers))
    }
    return (
        <>
            <div style={{ fontSize: '80px', marginBottom: '100px', textAlign: "center", backgroundColor: 'yellow' }}>미적분학 퀴즈</div>
            <img src={fight} style={{ position: "absolute", left: "1050px", top: '200px' }} alt="lion" />
            <div className="Quiz" >
                <h1><img src={logo} style={{ marginLeft: "450px" }} width='75' height='75' alt='question' /> <span style={{ fontSize: "75px", marginLeft: "30px" }}>{question.Q}</span></h1>
                {/* <div style={{ marginTop: "30px", marginBottom: "30px", marginLeft:'450px', fontSize:'40px' }}>정답을 선택하세요</div> */}

                <div>
                    <form>
                        {question.Choose.map((a, index) =>
                            <div key={index}>
                                <input type="radio" name='answer' id={index} value={a} onClick={handleChange} style={{ marginLeft: "475px", width: "25px", height: "25px" }} />
                                <label htmlFor={a} style={{ fontSize: "40px", marginLeft: "22px" }}>{a}</label>
                            </div>
                        )}
                        <input hidden type="submit" value="확인" />    {/*버튼 숨김*/}
                    </form>
                    <p style={{ fontSize: "40px", marginLeft: "480px" }}>Answer :<span style={{ color: "green", fontWeight: "bold", fontSize: "90px", marginLeft: "30px" }}> {selected}</span>  {/* 선택한 값 보여줌 */}<span style={{ marginLeft: "50px" }}>            {(question.page === QnA.length - 1)
                        ? <Link to="/end">제출</Link>
                        : <button type="button" onClick={handleQuestion} style={{ width: "85px", height: "40px" }} >다음</button>

                    }</span>
                    </p>
                </div>

                {/* 마지막 질문일 경우 /end페이지로 이동, 그렇지 않을경우는 this.handleQuestion발생 */}
                {/* {(question.page === QnA.length - 1)
                ? <Link to="/end">제출</Link>
                : <button type="button" onClick={handleQuestion} >다음</button>
            } */}

                {/* <input onKeyPress="this.enterkey()"/> */}

                <p style={{ textAlign: "center", fontSize: "30px", color: "crimson" }}>
                    <Timer
                        initialTime={3600000}
                        direction="backward"
                        checkpoints={[
                            {
                                time: 0,
                                callback: <Link to="/end">제출</Link>
                                //  history.go(1)
                            }
                        ]}
                    >
                        {() => (
                            <>
                                <Timer.Minutes /> : <Timer.Seconds></Timer.Seconds> / 60 : 00                        </>
                        )}
                    </Timer>     {/* npm i react-compound-timer */}
                </p>
            </div>
        </>
    )
}


export default Quiz;
