import React from 'react';
import Home from './Home'
import Quiz from './Quiz'
import End from './End'
import Admin from './Admin'

import { BrowserRouter as Router, Link, Switch, Route, Redirect } from 'react-router-dom';

function App() {
  return (
    <Router>
      <div className="container-fluid vh-100 bg-light">
        <header className="border-bottom">
          <Link to="/">
            <button className="ml-3 btn btn-light btn-lg font-weight-bold text-info">Home</button>
          </Link>
        </header>
        <Switch>
          <Route exact path="/" component={Home} />

          <Route path="/quiz" component={Quiz} />

          <Route path="/end" component={End} />

          <Route path="/admin" component={Admin} />

          <Redirect path="/admin" to="/admin" />
        </Switch>
      </div>


    </Router>
  )
}


export default App;