import React from 'react'
import { Link } from 'react-router-dom';
import Timer from 'react-compound-timer';

const question = [
    { Q: "6 X 4 ?", Choose: [6, 12, 18, 24], A: "" },
    { Q: "3 + 3 ?", Choose: [2, 4, 6, 8], A: "" },
    { Q: "3 - 1 ?", Choose: [1, 2, 3, 4], A: "" }
]

class Quiz extends React.Component {
    constructor(props) {
        super(props)
        this.setQuestion = this.setQuestion.bind(this)
        this.answerbox = this.answerbox.bind(this)
        this.state = {
            ...question[0],
            i: 0,
            page: 0,
        }
    }
    setQuestion() {
        //값이 입력되지 않은채로 넘겨졌을 때 문제 해결 해야 함-sj-
        this.setState({ ...question[this.state.i + 1], i: this.state.i + 1, page: this.state.page + 1 })
    }
    //answerbox - answer박스의 값을 네임리스트로 받아와서 값을 localstorage에 저장 
    answerbox() {
        let answers = document.getElementsByName('answer');
        let count = answers.length
        // let checked_index = -1;
        let checked_value = '';
        for (let i = 0; i < count; i++) {
            if (answers[i].checked) {
                // checked_index = i;
                checked_value = answers[i].value;
                localStorage.setItem('answer-' + i, checked_value)
            }
        }
    }

    render() {
        return (
            <div className="Quiz">
                <h2>Q:{this.state.Q}</h2>
                {this.answerbox()}
                {this.state.Choose.map((a) =>
                    <div>
                        <input type="radio" name='answer'  id={'anwer'+a} value={a} /*ref={this.textInput}  input 네임을 문제단위로 바꾸어주어야 함. */ />
                        <label for={a}>{a}</label>
                    </div>)                   

                }
                <div className="App" class='left'>정답을 입력하세요</div>

                
                {/* 마지막 질문일 경우 /end페이지로 이동, 그렇지 않을경우는 this.setQuestion발생 */}
                {(this.state.page === question.length-1)
                    ? <Link to="/end">제출</Link>
                    : <button type="button" onClick={this.setQuestion}>다음</button>
                    
                }
                                
               <Timer
                    initialTime={5000}
                    direction="backward"
                    checkpoints={[
                        {
                            time: 0,
                            callback: () =>  this.setQuestion,
                        }
                    ]}
                >
                    {() => (
                        <>
                            <Timer.Seconds /> seconds
                        </>
                    )}
                </Timer> {/* npm i react-compound-timer */}
               
            </div>
        )
    }
}

export default Quiz;