import React, { useState, useEffect } from 'react'
import { Link, Redirect } from 'react-router-dom';
import Timer from 'react-compound-timer'; // 타이머쓰기위해 import
import logo from './img/img_question.png'

let localQnA = JSON.parse(localStorage.getItem('QnA'))

let Answers = []

function Quiz() {
    const [question, setQuestion] = useState({
        ...localQnA[0]
    })
    const [selected, setSelected] = useState("")  //선택한 답을 보여줄 것

    const [timeout, settimeout] = useState(false)
    //for each 사용하기
    let Solutions = []          //빈 배열
    console.log(localQnA)
    localQnA.map((x) => {      //A만 꺼내서 q에 추가
        // Answers.push(0)
        return Solutions.push(x.A)
    })
    useEffect(() => {
        for (let i = 1; i <= Solutions.length; i++) {
            Answers.push(0)
            localStorage.setItem('Answers', JSON.stringify(Answers))
            localStorage.setItem("Solutions", JSON.stringify(Solutions))
        }
    }, [])



    //그걸 로컬에 저장
    //foreach 쓰기
    let finalQnA = localQnA.map((x, index) => {
        //delete x.A                       //A 삭제
        return { ...x, N: index + 1 }    //N 추가
    })

    function handleQuestion() {
        setQuestion({ ...localQnA[question.N] })
        setSelected("") //페이지 넘어가면 selected 초기화
    }

    let handleChange = (ev) => {
        setSelected(ev.target.value)  //selected값 변경
        Answers[question.N - 1] = Number(ev.target.id) + 1
        localStorage.setItem('Answers', JSON.stringify(Answers))
    }
    return (
        <>
            <div className="container-fluid">
                <div className="text-center h2 font-weight-bold bg-warning py-2">미적분학 퀴즈</div>
                <div className="row justify-content-md-center" >
                    <div className="col text-right">
                        <h1>
                            <img src={logo} width='50' height='50' alt='question' />
                        </h1>
                    </div>
                    <div className="col-md-auto">
                        <div className="h2 mt-2">
                            {localQnA[0].Q}
                        </div>
                        <div className="mt-2">
                            <form>
                                {question.Choose.map((a, index) =>
                                    <div>
                                        <input type="radio" name='answer' id={index} value={a} onChange={handleChange} checked={selected === String(a)} />
                                        <label className="font-weight-bold" htmlFor={a}>{a}</label>
                                    </div>
                                )}
                            </form>
                            <span className="h5 font-weight-bold"> Your Answer :</span>
                            <span className="h2 font-weight-bold text-danger"> {selected}</span>  {/* 선택한 값 보여줌 */}
                            <div className="text-center my-3"> {(question.N - 1 === localQnA.length - 1)
                                ? <Link to="/end">
                                    <button className="btn btn-outline-success" /*onClick={localStorage.setItem('Solutions', JSON.stringify(Solutions))}*/>제출</button>
                                </Link>
                                : <button type="button" className="btn btn-outline-dark" onClick={handleQuestion}>다음</button>
                            }
                            </div>
                            <p className="h3 text-center text-danger ">
                                <Timer
                                    initialTime={30010}
                                    direction="backward"
                                    checkpoints={[
                                        {
                                            time: 1,
                                            callback: () => alert('시간이 초과되었습니다.'),
                                        },
                                        {
                                            time: 0,
                                            callback: () => settimeout(true),

                                        }
                                    ]}
                                >
                                    {() => (
                                        <>
                                            <Timer.Minutes /> : <Timer.Seconds></Timer.Seconds> / 30 : 00                        </>
                                    )}
                                </Timer>     {/* npm i react-compound-timer */}
                            </p>
                        </div>
                    </div>
                    <div className="col">
                    </div>
                </div>
            </div>
            {timeout ? <Redirect to='/end' /> : ''}
        </>
    )



}


export default Quiz;
