import express from 'express'
import userCtrl from '../controllers/user.controller.js'

const router = express.Router()

router.route('/users/signup')
    .post(userCtrl.signup)


router.route('/users/check')
    .get(userCtrl.checkUser)

router.route(`/users/:userId`)
    .get(userCtrl.getProfile)
    .put(userCtrl.profileUpload, userCtrl.update)


router.param('userId', userCtrl.userById)



export default router