import mongoose from 'mongoose'

const { String } = mongoose.Schema.Types

const EntryLogSchema = new mongoose.Schema({
    userId: {
        type: mongoose.ObjectId,
        required: true,
        ref: 'User',
    },
    room: {
        type: mongoose.ObjectId,
        required: true,
        ref: 'Room',
    },
    leaveTime: {
        type: String,
        required: true,
    }
}, {
    timestamps: true
})

export default mongoose.models.EntryLog || mongoose.model('EntryLog', EntryLogSchema)
