import Room from "../models/Room.js"
import { customAlphabet } from 'nanoid'
import isLength from 'validator/lib/isLength.js'

const nanoid = customAlphabet('1234567890abcdef', 10)

const makeRoom = async (req, res) => {
    console.log(req.body)
    const { roomName, interest, isOpen, member } = req.body;
    console.log('콘솔확인', roomName, interest, isOpen, member)
    //console.log('member저장', member)
    const roomId = nanoid()
    const room = await Room.findOne({ roomId })
    while (room) {
        roomId = nanoid()
        room = await Room.findOne({ roomId })
    }

    try {
        if (!isLength(roomName, { min: 3, max: 20 })) {
            return res.status(422).send('채팅방의 이름은 3-20자여야 합니다.')
        } else if (interest == 'Choose...' || interest == '') {
            return res.status(422).send('분야를 반드시 선택하여야 합니다.')
        }
        const newRoom = await new Room({
            roomId,
            roomName,
            interest,
            isOpen,
            member,
        }).save()
        console.log(newRoom)
        res.json(newRoom)
    } catch (error) {
        console.log(error)
        res.status(500).send('방생성 에러')
    }
}

const getClosedList = async (req, res) => {
    try {
        console.log('req확인',req.query._id)
        let list = await Room.find({ member: req.query._id })
        console.log('c_list가져오기', list)
        return res.json(list)
    } catch (error) {
        res.status(500).send('리스트 불러오기를 실패하였습니다!')
    }
}


const getOpenList = async (req, res) => {
    try {
        let list = await Room.find({ isOpen: true })
        console.log('o_list가져오기', list)
        return res.json(list)
    } catch (error) {
        res.status(500).send('리스트 불러오기를 실패하였습니다!')
    }
}

// const getMemberId = async (req, res) => {
//     try {
//         console.log('roomId 확인', req.query.roomId)
//         let room = await Room.findOne({ roomId: req.query.roomId })
//         console.log('room', room)
//         const memId = room.member
//         console.log('memberId', memId)
//         return res.json(memId)
//     } catch (error) {
//         res.status(500).send('참여자 아이디 불러오는것을 실패하였습니다!')
//     }
// }

const changemember = async (req, res) => {
    // const memberId = req.memberId
    const { userId, roomId } = req.body
    console.log('userId:',userId)
    let room = await Room.findOne({ roomId: roomId }).select('member')
    console.log('room.member:',room.member)
    const isPresent = room.member.indexOf(userId)
    console.log('isPresent',isPresent)
    try {
        if (isPresent<0) {
            // const member = room.member.toString()
            // console.log('member:', member)
            const memberId = room.member.push(userId)
            console.log('memberId:',memberId)
            await Room.updateOne({ 'roomId': roomId }, { 'member': room.member })
            return res.json(true)
        }
        else {
            return res.json(false)
        }
        res.end()

    } catch (error) {
        console.log(error)
        res.status(500).send('멤버 업데이트 실패')
    }
}

const roomInf = async (req, res) => {
    try {
        console.log(req.query.roomId)
        // let roomInf = await Room.findOne({ member: req.query.roomId }).select('interest roomId member').exec()
        let roomInf = await Room.find({ roomId: req.query.roomId })
        console.log('room_member로 정보 가져오기:', roomInf)
        return res.json(roomInf)
    } catch (error) {
        alert('올바르지 못한 접근입니다.')
    }
}

export default { makeRoom, getClosedList, getOpenList, changemember, roomInf }
