import React, { useState, useEffect } from 'react'
import { ListGroup } from 'react-bootstrap';
import axios from 'axios'

function OpenList(props) {
  const [openlist, setOpenlist] = useState([])

  useEffect(() => {
    getOpenList();
  }, [props.roomCode]);

  async function getOpenList() {
    let res = await axios.get('/room/openlist')
    setOpenlist(res.data)
  }

  async function enterChatRoomCH(e) {
    const roomId = e.target.name
    console.log(roomId)
    props.openListroom(roomId) // 각각의 room으로 들어가도록 설정해야 함
    props.setRoomName(roomId)
    // props.clearChat()
  }

  return (
    <div>
      {openlist.map((item, index) =>
        <ListGroup key={index}>
          <ListGroup.Item action onClick={enterChatRoomCH} name={item.roomId}>
            {item.roomName}
          </ListGroup.Item>
        </ListGroup>
      )}
    </div>
  )
}

export default OpenList
