import React, { useState } from 'react';
import { Button, Form, Container, Navbar } from 'react-bootstrap';
import { Link } from 'react-router-dom';
import Menu from '../Components/Menu';

function SingUp() {
    const [validated, setValidated] = useState(false);

    const handleSubmit = (event) => {
        const form = event.currentTarget;
        if (form.checkValidity() === false) {
            event.preventDefault();
            event.stopPropagation();
        }

        setValidated(true);
    };

// async function addUser(user) {
//     await fetch(`http://localhost:3000/users`, {
//         method: 'POST',
//         headers: {
//             'Content-Type' : 'application/json'
//          },
//         body: JSON.stringify(user)
//         //json 형식으로 보냄.
//     })
// }

    function submitUser() {
        const username = document.querySelector('#username')
        const nickname = document.querySelector('#nickname')
        const email = document.querySelector('#email')
        const password = document.querySelector('#password')

        const user = {
            username: username.value,
            nickname: nickname.value,
            email: email.value,
            password: password.value
        }

        console.log(user);
    }



    return (
        <>
            <Navbar bg="dark" variant="dark">
                <Navbar.Brand>YDK Messenger</Navbar.Brand>
            </Navbar>


            <div>
                <Form noValidate validated={validated} onSubmit={handleSubmit}>
                    <Container className="d-flex justify-content-center">
                        <div className="mt-5 p-5 shadow w-75">

                            <h2 className="text-center ">회원가입</h2>

                            <Form.Group controlId="formGroupUsername">
                                <Form.Label>이름</Form.Label>
                                <Form.Control
                                    required
                                    type="text"
                                    id="username"
                                    placeholder="이름을 입력해주세요" />
                                <Form.Control.Feedback type="invalid">
                                    필수 정보입니다! 이름을 입력해주세요!
                            </Form.Control.Feedback>
                            </Form.Group>

                            <Form.Group controlId="formGroupNickname">
                                <Form.Label>별명</Form.Label>
                                <Form.Control
                                    required
                                    type="text"
                                    id="nickname"
                                    placeholder="별명을 입력해주세요" />
                                <Form.Control.Feedback type="invalid">
                                    필수 정보입니다! 별명을 입력해주세요!
                            </Form.Control.Feedback>
                            </Form.Group>

                            <Form.Group controlId="formGroupEmail">
                                <Form.Label>이메일</Form.Label>
                                <Form.Control
                                    required
                                    type="email"
                                    id="email"
                                    placeholder="이메일을 입력해주세요" />
                                <Form.Control.Feedback type="invalid">
                                    필수 정보입니다! 이메일을 입력해주세요!
                            </Form.Control.Feedback>
                            </Form.Group>

                            <Form.Group controlId="formGroupPassword">
                                <Form.Label>비밀번호</Form.Label>
                                <Form.Control
                                    required
                                    type="password"
                                    id="password"
                                    placeholder="비밀번호를 입력해주세요" />
                                <Form.Control.Feedback type="invalid">
                                    필수 정보입니다! 비밀번호를 입력해주세요!
                            </Form.Control.Feedback>
                            </Form.Group>


                            <Link to="./login">
                                <Button type="submit" onClick={{submitUser}} variant="outline-success" size="lg" className="mr-4" block>가입</Button>
                            </Link>
                        </div>
                    </Container>
                </Form>
            </div >
        </>
    )
}

export default SingUp