import User from "../models/User.js"
import isLength from 'validator/lib/isLength.js'
import isEmail from 'validator/lib/isEmail.js'
import bcrypt from "bcryptjs";
import jwt from 'jsonwebtoken'
import config from "../config.js"
//꼭 js붙여주기!!

//sign validation해야됨
const signup = async (req, res) => {

    const { username, nickname, email, password } = req.body
    //req.body를 구조분해하여 각각 보이게함 -> 모든정보들이 한줄에 보임
    console.log(username, nickname, email, password)

    try {
        if (!isLength(username, { min: 3, max: 10 })) {
            //이범위를 벗어나면 error발생
            return res.status(422).send('이름은 3-10자 사이입니다')
            //422 : 형식이 잘못되었다는 error발생
        } else if (!isLength(nickname, { min: 2, max: 10 })) {
            return res.status(422).send('별명은 2-10자 사이입니다.')
        } else if (!isLength(password, { min: 6 })) {
            return res.status(422).send('비밀번호는 6자 이상입니다.')
        } else if (!isEmail(email)) {
            return res.status(422).send('유효하지 않은 이메일 형식입니다')
        }
        // else if (!isLength(nickname, { min: 3, max: 10 })) {
        //     return res.status(422).send('Nickname must be 3-10 characters')
        // } else if (!isEmail(email, {
        //     allow_display_name: true,
        //     require_display_name: true,
        //     allow_utf8_local_part: false,
        // })) {
        //     return res.status(422).send('Email does not fit the format')
        // } else if (!isLength(password, { min: 6, max: 25 })) {
        //     return res.status(422).send('Nickname must be 6-25 characters')
        // }

        // 기존의 email이 있으면 나오는 error (unique)
        const user = await User.findOne({ email })
        if (user) {
            return res.status(422).send(`${email}이 이미 사용중입니다.`)
        }

        const hash = await bcrypt.hash(password, 10)
        //promise이므로 await사용함

        const newUser = await new User({
            username,
            nickname,
            email,
            password: hash,
            //required를 하였기 때문에 이중 하나라도 없으면 에러 발생
        }).save()
        //save시 user schema형식에 맞는지 확인후 틀리면 error발생 맞으면 mongooDb로 들어감
        //save(promise)붙일 시 fuction 앞에 await 붙여주기 + async 함수 앞에 붙여주기
        console.log(newUser)
        res.json(newUser)

    } catch (error) {
        //알수없는 모든 에러발생시 처리
        console.log(error)
        res.status(500).send('회원가입 에러발생하였습니다.')
    }
}
const hello = async (req, res) => {
    let users = await User.find().select('name nickname email _id').exec()
    return res.json(users)
}



const logineduser = async (req, res) => {
    try {
        let user = await User.findOne(req.body).select('username email nickname').exec()
        return res.json(user)
    } catch (error) {
        alert('올바르지 못한 접근입니다.')
    }
}

const changenick = async (req, res) => {
    try {
        const newnick = req.body.nickname
        await User.update({ 'username': req.body.username }, { 'nickname': newnick })
    } catch (error) {
        alert('올바르지 못한 접근입니다.')
    }
}


export default { signup, hello, logineduser, changenick }
// {} : 객체로 return함