import User from "../models/User.js"
import isLength from 'validator/lib/isLength.js'

const signup = async (req, res) => {
    const { name, email, password } = req.body
    try {
        if (!isLength(name, { min: 3, max: 10 })) {
            return res.status(422).send('Name must be 3-10 characters')
        }
        const newUser = await new User({
            name,
            email,
            password
        }).save()
        console.log(newUser)
        res.json(newUser)
    } catch (error) {
        console.log(error)
        res.status(500).send('User signup error')
    }
}

const hello = (req, res) => {
    res.send('Hello from users controller')
}

export default { signup, hello }