import React, { useState, useEffect } from 'react';
import { Row, Col, Button } from 'react-bootstrap';
import Tabs from 'react-bootstrap/Tabs';
import Tab from 'react-bootstrap/Tab';
import ClosedList from '../Components/ClosedList';
import OpenList from '../Components/OpenList';
import Menu from '../Components/Menu';
import { io } from "socket.io-client";   //모듈 가져오기
import Chat from "../Components/Chat";
import RoomMake from "../Components/RoomMake"
import EnterRoom from "../Components/EnterRoom"

const socket = io();

function Home() {
  const userName = sessionStorage.getItem('name')

  const [showModal, setShowModal] = useState(false);
  const [showEnter, setEnter] = useState(false);
  const [chat, setChat] = useState(false);

  //소켓
  const [singleChat, setSingleChat] = useState('')
  const [recievedMsg, setRecievedMsg] = useState('')
  const [roomCode, setRoomCode] = useState('')
  const [newUser, setNewUser] = useState('')

  const [singleUser, setSingleUser] = useState('')
  const [recievedUser, setRecievedUser] = useState('')

  const [singleImg, setSingleImg] = useState('')
  const [recievedImg, setRecievedImg] = useState('')


  //SOCKET 관련 시작
  function enterChatRoom(rCode) {    //방 입장하기
    socket.emit('joinRoom', rCode)
    socket.emit('newUser', { rmIf: rCode, userInfo: userName })
    console.log(`joinRoom : ${rCode} 입장`)
  }
  const [roomName, setRoomName] = useState('')

  const handleCloseModal = () => setShowModal(false);
  const handleShowModal = () => setShowModal(true);
  const handleCloseEnter = () => setEnter(false);
  const handleShowEnter = () => setEnter(true);
  const handleChato = () => setChat(true);
  const handleChatc = () => setChat(false);

  socket.on("sendUser", (data) => {
    setNewUser(data)
  })

  useEffect(() => {
    if (!(singleChat == '')) {
      socket.emit("chat", {
        roomInfo: roomCode,
        sendInfo: {
          msg: singleChat,
          sender: singleUser,
          img: singleImg
        }
      })
      setSingleChat([''])
    }
  }, [singleChat])


  useEffect(() => {
    socket.on("sendedMSG", (msg) => {
      setRecievedImg(sendInfo.img)
      setRecievedUser(sendInfo.sender)
      setRecievedMsg(sendInfo.msg)
    })
  }, [])

  return (
    <>
      <Menu />
      <Row className="mr-0">
        <Col className="list" md={5}>
          <Tabs defaultActiveKey="closed" id="uncontrolled-tab-example">
            <Tab eventKey="closed" title="내 채팅" onClick={handleChato} >
              <ClosedList enterChatRoom={enterChatRoom} setRoomCode={setRoomCode} />
            </Tab>
            <Tab eventKey="open" title="공개방" onClick={handleChato}>
              <OpenList enterChatRoom={enterChatRoom} setRoomCode={setRoomCode} />
            </Tab>
          </Tabs>
        </Col>
        <Col style={{ padding: "0" }}>

          {chat ? <Chat handleChatc={handleChatc} sendMsg={sendMsg} singleChat={singleChat} recievedMsg={recievedMsg} newUser={newUser} setSingleChat={setSingleChat} roomCode={roomCode} singleImg={singleImg} setSingleImg={setSingleImg} recievedImg={recievedImg} singleUser={singleUser} setSingleUser={setSingleUser} recievedUser={recievedUser} /> : <div style={{ position: "fixed", bottom: "20px", right: "30px" }}>
            <Button variant="primary" onClick={handleShowModal} size="lg" block>
              생성
                        </Button>

            <Button variant="secondary" onClick={handleShowEnter} size="lg" block>
              참가
                        </Button>
          </div>}
        </Col>
      </Row>
      <RoomMake showModal={showModal} handleCloseModal={handleCloseModal} />
      <EnterRoom showEnter={showEnter} enterChatRoom={enterChatRoom} handleCloseEnter={handleCloseEnter} handleChato={handleChato} setRoomName={setRoomName} />
    </>
  );
}

export default Home;

