import React from 'react'
import { Navbar, Nav } from 'react-bootstrap';
import { handleLogout } from '../utils/auth';


function Menu() {

  const name = sessionStorage.getItem('name');

  return (
    <Navbar style={{ backgroundColor: "#61477a" }} variant="dark">
      <div className="container-fluid">
        <Navbar.Brand className="navbar-brand" href="/home">YDK Messenger</Navbar.Brand>
        {name ?
          <>
            <Nav className="nav navbar-nav mr-auto" style={{ color: 'white' }}>
              <Nav.Item className="mt-2 mr-4">{name}님 환영합니다</Nav.Item>
              <Nav.Link href="/profile">Profile</Nav.Link>
              <Nav.Link onClick={() => handleLogout()} href="/login">logout</Nav.Link>
            </Nav>
          </>
          : <>
            <Nav className="nav navbar-nav">
              <Nav.Link href="/login">Login</Nav.Link>
              <Nav.Link href="/signup">Signup</Nav.Link>
            </Nav>
          </>}
      </div>
    </Navbar>
  )
}


export default Menu
