import express from 'express'
import userCtrl from '../controllers/user.controller.js'

const router = express.Router()
//router의 역할 : './주소'부분을 처리하는 역할함. 

router.route('/users/signup')
    .post(userCtrl.signup)
    .get(userCtrl.hello)

router.route(`/users/:userId`)
    .post(userCtrl.logineduser)
    .put(userCtrl.changenick)
    .get(userCtrl.loginNavbar)

// router.param('userId', userCtrl.userById)

// router.route('/api/users/signup/:userId')    //로그인한 사람의 정보만 가져오도록
//     .get



// /api/users/signup로 들어오는 것을 post (method) 를 통해 useCtrl.signup 이것이 처리함
//browser에서 주소창에 치고 들어가면 get (method) 을 타고 들어간것임
//post를 띄우고 싶으면 앱에서 ARC실행해서 post를 실행하게 만들면됨.
//객체에 접근할때는 .을 찍고 접근함/ ex) .hello
//express middleware : (req, res) => {}
//node(req(client의 정보), res)를 넘겨줌.

export default router